/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry.displays;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemappingMap<K, V>
extends ForwardingMap<K, V> {
    protected final Map<K, V> map;
    protected final UnaryOperator<V> remapper;
    protected final Predicate<K> keyPredicate;

    public RemappingMap(Map<K, V> map, UnaryOperator<V> remapper, Predicate<K> keyPredicate) {
        this.map = map;
        this.remapper = remapper;
        this.keyPredicate = keyPredicate;
    }

    @NotNull
    protected Map<K, V> delegate() {
        return this.map;
    }

    public V get(Object key) {
        if (this.keyPredicate.test(key)) {
            return (V)this.remapper.apply(super.get(key));
        }
        return null;
    }

    public boolean containsKey(@Nullable Object key) {
        return super.containsKey(key) && this.keyPredicate.test(key);
    }

    public Set<K> keySet() {
        return Sets.filter((Set)super.keySet(), this.keyPredicate::test);
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new ForwardingMap.StandardEntrySet(this){

            public Iterator<Map.Entry<K, V>> iterator() {
                return RemappingMap.this.mapIterator(RemappingMap.this.map.entrySet().iterator());
            }
        };
    }

    public int size() {
        return this.keySet().size();
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.transform(RemappingMap.this.entrySet().iterator(), Map.Entry::getValue);
            }

            @Override
            public int size() {
                return RemappingMap.this.size();
            }
        };
    }

    private Iterator<Map.Entry<K, V>> mapIterator(Iterator<Map.Entry<K, V>> iterator) {
        return Iterators.transform((Iterator)Iterators.filter(iterator, entry -> this.keyPredicate.test(entry.getKey())), this::mapEntry);
    }

    private Map.Entry<K, V> mapEntry(final Map.Entry<K, V> entry) {
        return new ForwardingMapEntry<K, V>(){

            @NotNull
            protected Map.Entry<K, V> delegate() {
                return entry;
            }

            public V getValue() {
                return RemappingMap.this.remapper.apply(entry.getValue());
            }
        };
    }
}

